/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jpos.config.JposEntry;
import jpos.config.simple.editor.AbstractPropsViewPanel;
import jpos.config.simple.editor.JposEntryEditorMsg;
import jpos.config.simple.editor.JposEntryEditorUtility;
import jpos.config.simple.editor.JposEntryProp;

class JposEntryViewPanel
extends AbstractPropsViewPanel {
    private boolean showNumbersAsHex = false;
    private JposEntry jposEntry = null;
    private JposEntryProp currentProp = null;
    private JTextField logicalNameTextField = new JTextField(20);
    private JTextField siFactoryClassNameTextField = new JTextField(25);
    private JTextField currentPropNameTextField = new JTextField(25);
    private JTextField currentPropValueTextField = new JTextField(25);
    private JComboBox currentPropValueTypeComboBox = new JComboBox<String>(PROPERTY_VALUE_TYPES);
    private DefaultListModel propListModel = new DefaultListModel();
    private Vector propertiesVector = new Vector();
    private JList propertiesList = new JList();
    private static final String[] PROPERTY_VALUE_TYPES = new String[]{"String", "Integer", "Boolean", "Long", "Float", "Byte", "Character"};
    public static final String EDITPROPERTYNAME_STRING = JposEntryEditorMsg.EDITPROPERTYNAME_STRING;
    public static final String EDITPROPERTYVALUE_STRING = JposEntryEditorMsg.EDITPROPERTYVALUE_STRING;
    public static final String EDITPROPERTYTYPE_STRING = JposEntryEditorMsg.EDITPROPERTYTYPE_STRING;
    public static final String LOGICALNAMETEXT_STRING = JposEntryEditorMsg.LOGICALNAMETEXT_STRING;
    public static final String SIFACTORYCLASSTEXT_STRING = JposEntryEditorMsg.SIFACTORYCLASSTEXT_STRING;
    public static final String CURRENTPROPNAMETEXT_STRING = JposEntryEditorMsg.CURRENTPROPNAMETEXT_STRING;
    public static final String CURRENTPROPVALUETEXT_STRING = JposEntryEditorMsg.CURRENTPROPVALUETEXT_STRING;
    public static final String CURRENTPROPERTY_STRING = JposEntryEditorMsg.CURRENTPROPERTY_STRING;
    public static final String OTHERPROPERTIES_STRING = JposEntryEditorMsg.OTHERPROPERTIES_STRING;
    public static final String IMPORTANTPROPERTIES_STRING = JposEntryEditorMsg.IMPORTANTPROPERTIES_STRING;

    public JposEntryViewPanel() {
        this.setLayout(new GridLayout(3, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), IMPORTANTPROPERTIES_STRING, 1, 2));
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(new JLabel("logicalName:"));
        jPanel2.add(this.logicalNameTextField);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(new JLabel("serviceInstanceFactoryClass:"));
        jPanel2.add(this.siFactoryClassNameTextField);
        jPanel.add(jPanel2);
        this.add(jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), CURRENTPROPERTY_STRING, 1, 2));
        jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(new JLabel(EDITPROPERTYNAME_STRING));
        jPanel2.add(this.currentPropNameTextField);
        jPanel3.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(new JLabel(EDITPROPERTYVALUE_STRING));
        jPanel2.add(this.currentPropValueTextField);
        jPanel3.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(new JLabel(EDITPROPERTYTYPE_STRING));
        jPanel2.add(this.currentPropValueTypeComboBox);
        jPanel3.add(jPanel2);
        this.add(jPanel3);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), OTHERPROPERTIES_STRING, 1, 2));
        JScrollPane jScrollPane = new JScrollPane(22, 30);
        jScrollPane.setViewportView(this.propertiesList);
        jPanel4.add((Component)jScrollPane, "Center");
        this.add(jPanel4);
        this.init();
        this.propertiesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JposEntryViewPanel.this.listSelectionValueChanged(listSelectionEvent);
            }
        });
    }

    private void init() {
        this.logicalNameTextField.setEditable(false);
        this.siFactoryClassNameTextField.setEditable(false);
        this.currentPropNameTextField.setEditable(false);
        this.currentPropValueTextField.setEditable(false);
        this.currentPropValueTypeComboBox.setEditable(false);
        this.currentPropValueTypeComboBox.setEnabled(false);
        this.defaultJTextFieldTTText();
    }

    private void listSelectionValueChanged(ListSelectionEvent listSelectionEvent) {
        this.currentProp = (JposEntryProp)this.propertiesList.getSelectedValue();
        if (this.currentProp == null) {
            return;
        }
        this.updateCurrentProp();
    }

    private void addPropToList(String string, Object object) {
        this.propListModel.addElement(new JposEntryProp(string, object));
    }

    private void setJTextFieldText(JTextField jTextField, String string) {
        jTextField.setText(string);
        if (string.length() > jTextField.getColumns()) {
            jTextField.setToolTipText(string);
        }
    }

    private void defaultJTextFieldTTText() {
        this.logicalNameTextField.setToolTipText(LOGICALNAMETEXT_STRING);
        this.siFactoryClassNameTextField.setToolTipText(SIFACTORYCLASSTEXT_STRING);
        this.currentPropNameTextField.setToolTipText(CURRENTPROPNAMETEXT_STRING);
        this.currentPropValueTextField.setToolTipText(CURRENTPROPVALUETEXT_STRING);
    }

    public void clearAll() {
        this.logicalNameTextField.setText("");
        this.siFactoryClassNameTextField.setText("");
        this.currentPropNameTextField.setText("");
        this.currentPropValueTextField.setText("");
        this.defaultJTextFieldTTText();
        this.propListModel.removeAllElements();
    }

    public void updateCurrentProp() {
        if (this.currentProp == null) {
            return;
        }
        this.setJTextFieldText(this.currentPropNameTextField, this.currentProp.getName());
        if (this.currentProp.getValueType().equalsIgnoreCase("integer")) {
            this.setJTextFieldText(this.currentPropValueTextField, JposEntryEditorUtility.formatText(this.currentProp.getValue().toString(), this.showNumbersAsHex));
        } else {
            this.setJTextFieldText(this.currentPropValueTextField, this.currentProp.getValue().toString());
        }
        this.currentPropValueTypeComboBox.setSelectedItem(this.currentProp.getValueType());
    }

    public void setEnabledAll(boolean bl) {
        this.logicalNameTextField.setEnabled(bl);
        this.siFactoryClassNameTextField.setEnabled(bl);
    }

    public void setEditableAll(boolean bl) {
        this.logicalNameTextField.setEditable(bl);
        this.siFactoryClassNameTextField.setEditable(bl);
    }

    public void addProperty(JposEntryProp jposEntryProp) {
        this.propListModel.addElement(jposEntryProp);
    }

    public void removeProperty(JposEntryProp jposEntryProp) {
        this.propListModel.removeElement(jposEntryProp);
    }

    public void refresh() {
        JposEntry jposEntry = this.getJposEntry();
        String string = (String)jposEntry.getPropertyValue("logicalName");
        String string2 = (String)jposEntry.getPropertyValue("serviceInstanceFactoryClass");
        if (string != null && string.equals("logicalName")) {
            this.setJTextFieldText(this.logicalNameTextField, string);
        } else if (string != null && string.equals("serviceInstanceFactoryClass")) {
            this.setJTextFieldText(this.siFactoryClassNameTextField, string2);
        }
        this.propertiesList.repaint();
    }

    public JposEntry getJposEntry() {
        return this.jposEntry;
    }

    public String getLogicalName() {
        return this.logicalNameTextField.getText();
    }

    public String getSIFactoryClassName() {
        return this.siFactoryClassNameTextField.getText();
    }

    public JposEntryProp getSelectedJposEntryProp() {
        return this.currentProp;
    }

    public Enumeration getJposEntryProps() {
        return ((DefaultListModel)this.propertiesList.getModel()).elements();
    }

    public void setJposEntry(JposEntry jposEntry) {
        this.jposEntry = jposEntry;
        this.clearAll();
        if (this.jposEntry == null) {
            return;
        }
        Enumeration enumeration = this.jposEntry.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("logicalName")) {
                this.setJTextFieldText(this.logicalNameTextField, (String)jposEntry.getPropertyValue("logicalName"));
                continue;
            }
            if (string.equals("serviceInstanceFactoryClass")) {
                this.setJTextFieldText(this.siFactoryClassNameTextField, (String)jposEntry.getPropertyValue("serviceInstanceFactoryClass"));
                continue;
            }
            this.addPropToList(string, jposEntry.getPropertyValue(string));
        }
        this.propertiesList.setModel(this.propListModel);
    }

    public boolean isListEmpty() {
        if (this.propListModel.isEmpty()) {
            this.clearCurrentPropFields();
            return true;
        }
        return false;
    }

    public void clearCurrentPropFields() {
        this.currentPropNameTextField.setText("");
        this.currentPropValueTextField.setText("");
        this.currentPropValueTypeComboBox.setSelectedIndex(0);
    }

    public void addPropertiesListSelectionListener(ListSelectionListener listSelectionListener) {
        this.propertiesList.addListSelectionListener(listSelectionListener);
    }

    public void removePropertiesListSelectionListener(ListSelectionListener listSelectionListener) {
        this.propertiesList.removeListSelectionListener(listSelectionListener);
    }

    public void setFocusOnLogicalName() {
        this.logicalNameTextField.requestFocus();
        if (this.logicalNameTextField.getText() != null && !this.logicalNameTextField.getText().equals("")) {
            this.logicalNameTextField.selectAll();
        }
    }

    public void setFocusOnSIFactoryClassName() {
        this.siFactoryClassNameTextField.requestFocus();
        if (this.siFactoryClassNameTextField.getText() != null && !this.siFactoryClassNameTextField.getText().equals("")) {
            this.siFactoryClassNameTextField.selectAll();
        }
    }

    public void enableLogicalNameTextField(boolean bl) {
        this.logicalNameTextField.setEditable(bl);
    }

    public boolean getShowNumbersAsHexFlag() {
        return this.showNumbersAsHex;
    }

    public void setShowNumbersAsHexFlag(boolean bl) {
        this.showNumbersAsHex = bl;
    }

    public void aboutToLooseFocus() {
        System.out.println("aboutToLooseFocus()");
    }

    public void editButtonClicked() {
        System.out.println("editButtonClicked");
    }

    public void okButtonClicked() {
        System.out.println("okButtonClicked");
    }

    public void cancelButtonClicked() {
        System.out.println("cancelButtonClicked");
    }
}

