/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jpos.config.JposEntry;
import jpos.config.simple.editor.CategoryTreeNodeUI;
import jpos.config.simple.editor.JposEntryEditorMsg;
import jpos.config.simple.editor.JposEntryList;
import jpos.config.simple.editor.JposEntryListEvent;
import jpos.config.simple.editor.JposEntryListListener;
import jpos.config.simple.editor.JposEntryTreeCellRenderer;
import jpos.config.simple.editor.JposEntryTreeEvent;
import jpos.config.simple.editor.JposEntryTreeListener;
import jpos.config.simple.editor.LeafTreeNodeUI;
import jpos.config.simple.editor.MainFrame;
import jpos.config.simple.editor.ManufacturerTreeNodeUI;
import jpos.util.PopupHelper;
import jpos.util.PopupListener;

class JposEntryTreePanel
extends JPanel {
    private JposEntryListListener jposEntryListListener = null;
    private Hashtable entriesTable = new Hashtable();
    private Hashtable nodesTable = new Hashtable();
    private JposEntryList jposEntryList = null;
    private JTree tree = new JTree();
    private MainFrame mainFrame = null;
    private DefaultMutableTreeNode entriesNode = new DefaultMutableTreeNode(ENTRIES_STRING);
    private Vector listeners = new Vector();
    private int currentView = 0;
    private boolean expandTreeFlag = false;
    public static final String UNKNOWN_STRING = JposEntryEditorMsg.UNKNOWN_STRING;
    public static final String ENTRIES_STRING = JposEntryEditorMsg.ENTRIES_STRING;
    public static final String JPOSENTRIES_STRING = JposEntryEditorMsg.JPOSENTRIES_STRING;

    public JposEntryTreePanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), JPOSENTRIES_STRING, 1, 1));
        ((DefaultTreeModel)this.tree.getModel()).setRoot(this.entriesNode);
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        JScrollPane jScrollPane = new JScrollPane(this.tree, 20, 30);
        this.add((Component)jScrollPane, "Center");
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                JposEntryTreePanel.this.valueChanged(treeSelectionEvent);
            }
        });
    }

    private JposEntryListListener getJposEntryListListener() {
        if (this.jposEntryListListener == null) {
            this.jposEntryListListener = new JposEntryListListener(){

                public void jposEntryAdded(JposEntryListEvent jposEntryListEvent) {
                    JposEntryTreePanel.this.jposEntryAdded(jposEntryListEvent);
                }

                public void jposEntryRemoved(JposEntryListEvent jposEntryListEvent) {
                    JposEntryTreePanel.this.jposEntryRemoved(jposEntryListEvent);
                }
            };
        }
        return this.jposEntryListListener;
    }

    private void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object = this.tree.getLastSelectedPathComponent();
        if (object == null) {
            return;
        }
        String string = object.toString();
        if (this.entriesTable.containsKey(string)) {
            JposEntry jposEntry = (JposEntry)this.entriesTable.get(string);
            this.fireJposEntryTreeEvent(new JposEntryTreeEvent(this, jposEntry));
        } else {
            this.mainFrame.getJposEntryPanel().setJposEntry(null);
            this.mainFrame.getJposEntryPanel().clearAll();
            this.mainFrame.enableCopyDeleteSubMenus(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJposEntryTreeEvent(JposEntryTreeEvent jposEntryTreeEvent) {
        Vector vector;
        Vector vector2 = vector = (Vector)this.listeners.clone();
        synchronized (vector2) {
            for (int i = 0; i < vector.size(); ++i) {
                ((JposEntryTreeListener)vector.elementAt(i)).newJposEntrySelected(jposEntryTreeEvent);
            }
        }
    }

    private void removeAllEntries() {
        this.entriesNode.removeAllChildren();
        this.entriesTable.clear();
        this.nodesTable.clear();
        this.tree.treeDidChange();
        this.tree.revalidate();
        this.tree.repaint();
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.collapseRow(i);
        }
    }

    private void jposEntryAdded(JposEntryListEvent jposEntryListEvent) {
        JposEntry jposEntry = jposEntryListEvent.getJposEntry();
        String string = (String)jposEntry.getPropertyValue("logicalName");
        this.entriesTable.put(string, jposEntry);
        LeafTreeNodeUI leafTreeNodeUI = new LeafTreeNodeUI(jposEntry);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(leafTreeNodeUI);
        this.nodesTable.put(string, defaultMutableTreeNode);
    }

    private void jposEntryRemoved(JposEntryListEvent jposEntryListEvent) {
        String string = (String)jposEntryListEvent.getJposEntry().getPropertyValue("logicalName");
        this.entriesTable.remove(string);
        this.nodesTable.remove(string);
        this.fireJposEntryTreeEvent(new JposEntryTreeEvent(this, null));
    }

    private void sortedButtonSelected() {
        this.currentView = 0;
        this.jposEntryList.sort();
        this.refreshTree();
    }

    private void byCategoryButtonSelected() {
        this.currentView = 1;
        this.refreshTree();
    }

    private void byManufacturerButtonSelected() {
        this.currentView = 2;
        this.refreshTree();
    }

    private void createNodesByManufacturer() {
        Object object;
        Enumeration enumeration = this.jposEntryList.getEntries();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (enumeration.hasMoreElements()) {
            object = (JposEntry)enumeration.nextElement();
            hashtable.put((String)object.getPropertyValue("vendorName"), new String(""));
        }
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            Enumeration enumeration2 = this.jposEntryList.getEntries();
            String string = (String)object.nextElement();
            ManufacturerTreeNodeUI manufacturerTreeNodeUI = new ManufacturerTreeNodeUI(string);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(manufacturerTreeNodeUI);
            while (enumeration2.hasMoreElements()) {
                JposEntry jposEntry = (JposEntry)enumeration2.nextElement();
                if (!((String)jposEntry.getPropertyValue("vendorName")).equalsIgnoreCase(string)) continue;
                String string2 = (String)jposEntry.getPropertyValue("logicalName");
                this.entriesTable.put(string2, jposEntry);
                LeafTreeNodeUI leafTreeNodeUI = new LeafTreeNodeUI(jposEntry);
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(leafTreeNodeUI);
                this.nodesTable.put(string2, defaultMutableTreeNode3);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
            if (!defaultMutableTreeNode2.getUserObject().toString().equalsIgnoreCase(UNKNOWN_STRING)) {
                this.entriesNode.add(defaultMutableTreeNode2);
                continue;
            }
            defaultMutableTreeNode = defaultMutableTreeNode2;
        }
        if (defaultMutableTreeNode != null) {
            this.entriesNode.add(defaultMutableTreeNode);
        }
    }

    private void createNodesByCategories() {
        Object object;
        Enumeration enumeration = this.jposEntryList.getEntries();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (enumeration.hasMoreElements()) {
            object = (JposEntry)enumeration.nextElement();
            hashtable.put(((String)object.getPropertyValue("deviceCategory")).toLowerCase(), new String(""));
        }
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            Enumeration enumeration2 = this.jposEntryList.getEntries();
            String string = ((String)object.nextElement()).toLowerCase();
            CategoryTreeNodeUI categoryTreeNodeUI = new CategoryTreeNodeUI(string);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(categoryTreeNodeUI);
            while (enumeration2.hasMoreElements()) {
                JposEntry jposEntry = (JposEntry)enumeration2.nextElement();
                if (!((String)jposEntry.getPropertyValue("deviceCategory")).equalsIgnoreCase(string)) continue;
                String string2 = (String)jposEntry.getPropertyValue("logicalName");
                this.entriesTable.put(string2, jposEntry);
                LeafTreeNodeUI leafTreeNodeUI = new LeafTreeNodeUI(jposEntry);
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(leafTreeNodeUI);
                this.nodesTable.put(string2, defaultMutableTreeNode3);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
            if (!defaultMutableTreeNode2.getUserObject().toString().equalsIgnoreCase(UNKNOWN_STRING)) {
                this.entriesNode.add(defaultMutableTreeNode2);
                continue;
            }
            defaultMutableTreeNode = defaultMutableTreeNode2;
        }
        if (defaultMutableTreeNode != null) {
            this.entriesNode.add(defaultMutableTreeNode);
        }
    }

    private void createNodes() {
        Enumeration enumeration = this.jposEntryList.getEntries();
        while (enumeration.hasMoreElements()) {
            JposEntry jposEntry = (JposEntry)enumeration.nextElement();
            if (!jposEntry.hasPropertyWithName("logicalName")) continue;
            String string = (String)jposEntry.getPropertyValue("logicalName");
            this.entriesTable.put(string, jposEntry);
            LeafTreeNodeUI leafTreeNodeUI = new LeafTreeNodeUI(jposEntry);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(leafTreeNodeUI);
            this.nodesTable.put(string, defaultMutableTreeNode);
            this.entriesNode.add(defaultMutableTreeNode);
        }
    }

    public void addJposEntryTreeListener(JposEntryTreeListener jposEntryTreeListener) {
        this.listeners.addElement(jposEntryTreeListener);
    }

    public void removeJposEntryTreeListener(JposEntryTreeListener jposEntryTreeListener) {
        this.listeners.removeElement(jposEntryTreeListener);
    }

    public void refreshTree() {
        this.removeAllEntries();
        if (!this.jposEntryList.isEmpty()) {
            this.tree.setCellRenderer(new JposEntryTreeCellRenderer());
            if (this.currentView == 0) {
                this.jposEntryList.sort();
                this.createNodes();
            } else if (this.currentView == 1) {
                this.createNodesByCategories();
            } else if (this.currentView == 2) {
                this.createNodesByManufacturer();
            }
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this.entriesNode);
            this.tree.setRootVisible(true);
            if (this.expandTreeFlag) {
                this.expandTree();
            }
        } else {
            this.tree.setRootVisible(false);
        }
    }

    public void setJposEntryList(JposEntryList jposEntryList) {
        this.jposEntryList = jposEntryList;
        if (this.jposEntryList == null) {
            this.removeAllEntries();
        } else {
            this.jposEntryList.addJposEntryListListener(this.getJposEntryListListener());
            this.createNodes();
            if (this.expandTreeFlag) {
                this.expandTree();
            }
        }
    }

    public JposEntryList getJposEntryList() {
        if (this.jposEntryList == null) {
            this.jposEntryList = new JposEntryList();
            this.setJposEntryList(this.jposEntryList);
        }
        return this.jposEntryList;
    }

    public boolean isJposEntryListEmpty() {
        return this.jposEntryList.isEmpty();
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void setTreeRootVisible(boolean bl) {
        this.tree.setRootVisible(bl);
    }

    public void expandTree() {
        if (this.expandTreeFlag) {
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                this.tree.expandRow(i);
            }
        }
    }

    public void setCurrentTreeView(int n) {
        this.currentView = n;
        if (this.jposEntryList != null && !this.jposEntryList.isEmpty()) {
            if (this.currentView == 1) {
                this.byCategoryButtonSelected();
            } else if (this.currentView == 2) {
                this.byManufacturerButtonSelected();
            } else {
                this.sortedButtonSelected();
            }
        }
    }

    public int getCurrentTreeView() {
        return this.currentView;
    }

    public void setExpandTreeFlag(boolean bl) {
        this.expandTreeFlag = bl;
    }

    public boolean getExpandTreeFlag() {
        return this.expandTreeFlag;
    }

    public void registerTreeForPopupMenu(JPopupMenu jPopupMenu, PopupListener popupListener) {
        PopupHelper.setPopup(this.tree, jPopupMenu, popupListener);
    }

    public int getSelectionCount() {
        return this.tree.getSelectionCount();
    }

    public TreePath[] getSelectionPaths() {
        return this.tree.getSelectionPaths();
    }

    public boolean isSelectionPathValid(int n, TreePath[] treePathArray) {
        JposEntry jposEntry = (JposEntry)this.entriesTable.get(treePathArray[n].getLastPathComponent().toString());
        return jposEntry != null;
    }

    public void setJposEntryToDelete(int n, TreePath[] treePathArray) {
        Object object = treePathArray[n].getLastPathComponent();
        String string = object.toString();
        JposEntry jposEntry = (JposEntry)this.entriesTable.get(string);
        this.mainFrame.getJposEntryPanel().setJposEntry(jposEntry);
    }
}

