/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.editor;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JOptionPane;
import jpos.config.simple.editor.JposEntryEditorMsg;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

class JposEntryEditorConfig
implements Serializable {
    private int mainFrameHDividerLocation = 170;
    private int mainFrameVDividerLocation = 405;
    private Point mainFrameLocation = DEFAULT_MAINFRAME_LOCATION;
    private Dimension mainFrameSize = DEFAULT_MAINFRAME_SIZE;
    private Point jposEntryMergerDialogLocation = DEFAULT_MERGER_DIALOG_LOCATION;
    private Dimension jposEntryMergerDialogSize = DEFAULT_MERGER_DIALOG_SIZE;
    private int currentLookAndFeel = 0;
    private int currentTreeView = 1;
    private boolean expandTreeCheckBox = true;
    private boolean showNumbersAsHexCheckBox = true;
    private boolean autoLoadCheckBox = true;
    private boolean autoDeleteEntryOnCopy = true;
    private boolean configSaved = false;
    private boolean showJCL12PropView = false;
    private String fileDialogPath = ".";
    private transient Tracer tracer = TracerFactory.getInstance().createTracer("JposEntryEditorConfig");
    private static JposEntryEditorConfig instance = null;
    public static final Dimension SCREENSIZE = Toolkit.getDefaultToolkit().getScreenSize();
    public static final int WIDTH_INT = JposEntryEditorConfig.SCREENSIZE.width;
    public static final int HEIGHT_INT = JposEntryEditorConfig.SCREENSIZE.height;
    public static final double WIDTH = WIDTH_INT;
    public static final double HEIGHT = HEIGHT_INT;
    public static final int DEFAULT_MAINFRAME_HSPLIT_DIVIDER_LOCATION = 170;
    public static final int DEFAULT_MAINFRAME_VSPLIT_DIVIDER_LOCATION = 405;
    public static final int MIN_SUPPORTED_WIDTH = 800;
    public static final int MIN_SUPPORTED_HEIGHT = 600;
    public static final int DEFAULT_MAINFRAME_WIDTH = Math.max(800, (int)(WIDTH * 0.75));
    public static final int DEFAULT_MAINFRAME_HEIGHT = Math.max(600, (int)(HEIGHT * 0.75));
    public static final Dimension DEFAULT_MAINFRAME_SIZE = new Dimension(DEFAULT_MAINFRAME_WIDTH, DEFAULT_MAINFRAME_HEIGHT);
    public static final int DEFAULT_MAINFRAME_X_LOCATION = (int)(WIDTH * 0.5 - (double)DEFAULT_MAINFRAME_WIDTH * 0.5);
    public static final int DEFAULT_MAINFRAME_Y_LOCATION = (int)(HEIGHT * 0.5 - (double)DEFAULT_MAINFRAME_HEIGHT * 0.5);
    public static final Point DEFAULT_MAINFRAME_LOCATION = new Point(DEFAULT_MAINFRAME_X_LOCATION, DEFAULT_MAINFRAME_Y_LOCATION);
    public static final int DEFAULT_CONFIGURATIONFRAME_WIDTH = 375;
    public static final int DEFAULT_CONFIGURATIONFRAME_HEIGHT = 125;
    public static final Dimension DEFAULT_CONFIGURATIONFRAME_SIZE = new Dimension(375, 125);
    public static final int DEFAULT_CONFIGURATIONFRAME_X_LOCATION = (int)(WIDTH * 0.5 - 187.5);
    public static final int DEFAULT_CONFIGURATIONFRAME_Y_LOCATION = (int)(HEIGHT * 0.5 - 62.5);
    public static final Point DEFAULT_CONFIGURATIONFRAME_LOCATION = new Point(DEFAULT_CONFIGURATIONFRAME_X_LOCATION, DEFAULT_CONFIGURATIONFRAME_Y_LOCATION);
    public static final int DEFAULT_MERGER_DIALOG_WIDTH = 482;
    public static final int DEFAULT_MERGER_DIALOG_HEIGHT = 138;
    public static final Dimension DEFAULT_MERGER_DIALOG_SIZE = new Dimension(482, 138);
    public static final int DEFAULT_MERGER_DIALOG_X_LOCATION = (int)(WIDTH * 0.5 - 241.0);
    public static final int DEFAULT_MERGER_DIALOG_Y_LOCATION = (int)(HEIGHT * 0.5 - 69.0);
    public static final Point DEFAULT_MERGER_DIALOG_LOCATION = new Point(DEFAULT_MERGER_DIALOG_X_LOCATION, DEFAULT_MERGER_DIALOG_Y_LOCATION);
    public static final String JCL_EDITOR_CONFIG_FILE_PATH = System.getProperty("user.home") + File.separator + ".jcl";
    public static final String JPOSENTRYEDITORCONFIG_FILE_NAME = "editor.config";
    public static final String DEFAULT_FILE_DIALOG_PATH = ".";
    public static final int SORTEDVIEW = 0;
    public static final int CATEGORYVIEW = 1;
    public static final int MANUFACTURERVIEW = 2;
    public static final int JAVALNF = 0;
    public static final int NATIVELNF = 1;
    public static final String JPOSENTRYEDITOR_STRING = JposEntryEditorMsg.JPOSENTRYEDITOR_STRING;
    public static final String ERRORSAVINGFILE_STRING = JposEntryEditorMsg.ERRORSAVINGFILE_STRING;

    JposEntryEditorConfig() {
    }

    public static synchronized JposEntryEditorConfig getInstance() {
        if (instance == null) {
            try {
                File file = new File(JCL_EDITOR_CONFIG_FILE_PATH + File.separator + JPOSENTRYEDITORCONFIG_FILE_NAME);
                FileInputStream fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                instance = (JposEntryEditorConfig)objectInputStream.readObject();
                objectInputStream.close();
            }
            catch (Exception exception) {
                instance = new JposEntryEditorConfig();
            }
        }
        return instance;
    }

    private void createDir() {
        File file = new File(JCL_EDITOR_CONFIG_FILE_PATH);
        if (!file.exists()) {
            boolean bl = file.mkdir();
            String string = bl ? "Created directory: " + JCL_EDITOR_CONFIG_FILE_PATH : "Could not create directory: " + JCL_EDITOR_CONFIG_FILE_PATH;
            this.tracer.println(string);
        }
    }

    public boolean isSaved() {
        return this.configSaved;
    }

    public void save() {
        try {
            this.createDir();
            this.configSaved = false;
            FileOutputStream fileOutputStream = new FileOutputStream(JCL_EDITOR_CONFIG_FILE_PATH + File.separator + JPOSENTRYEDITORCONFIG_FILE_NAME);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            objectOutputStream.close();
            this.configSaved = true;
        }
        catch (Exception exception) {
            this.tracer.println("save():Exception.message=" + exception.getMessage());
            this.configSaved = true;
            JOptionPane.showMessageDialog(null, ERRORSAVINGFILE_STRING, JPOSENTRYEDITOR_STRING, 0);
        }
    }

    public void reset() {
        this.mainFrameHDividerLocation = 170;
        this.mainFrameVDividerLocation = 405;
        this.mainFrameLocation = DEFAULT_MAINFRAME_LOCATION;
        this.mainFrameSize = DEFAULT_MAINFRAME_SIZE;
        this.jposEntryMergerDialogLocation = DEFAULT_MERGER_DIALOG_LOCATION;
        this.jposEntryMergerDialogSize = DEFAULT_MERGER_DIALOG_SIZE;
        this.currentLookAndFeel = 0;
        this.currentTreeView = 1;
        this.expandTreeCheckBox = true;
        this.showNumbersAsHexCheckBox = true;
        this.autoLoadCheckBox = true;
        this.autoDeleteEntryOnCopy = true;
        this.configSaved = false;
        this.showJCL12PropView = false;
        this.fileDialogPath = DEFAULT_FILE_DIALOG_PATH;
    }

    public Point getMainFrameLocation() {
        return this.mainFrameLocation;
    }

    public Dimension getMainFrameSize() {
        return this.mainFrameSize;
    }

    public Point getJposEntryMergerDialogLocation() {
        return this.jposEntryMergerDialogLocation;
    }

    public Dimension getJposEntryMergerDialogSize() {
        return this.jposEntryMergerDialogSize;
    }

    public int getMainFrameHDividerLocation() {
        return this.mainFrameHDividerLocation;
    }

    public int getMainFrameVDividerLocation() {
        return this.mainFrameVDividerLocation;
    }

    public int getCurrentLookAndFeel() {
        return this.currentLookAndFeel;
    }

    public int getCurrentTreeView() {
        return this.currentTreeView;
    }

    public boolean getExpandTreeCheckBox() {
        return this.expandTreeCheckBox;
    }

    public boolean getShowNumbersAsHexCheckBox() {
        return this.showNumbersAsHexCheckBox;
    }

    public boolean getAutoLoadCheckBox() {
        return this.autoLoadCheckBox;
    }

    public boolean getAutoDeleteEntryOnCopy() {
        return this.autoDeleteEntryOnCopy;
    }

    public boolean isShowJCL12PropView() {
        return this.showJCL12PropView;
    }

    public String getFileDialogPath() {
        return this.fileDialogPath;
    }

    public void setMainFrameLocation(Point point) {
        this.mainFrameLocation = point;
    }

    public void setMainFrameSize(Dimension dimension) {
        this.mainFrameSize = dimension;
    }

    public void setJposEntryMergerDialogLocation(Point point) {
        this.jposEntryMergerDialogLocation = point;
    }

    public void setJposEntryMergerDialogSize(Dimension dimension) {
        this.jposEntryMergerDialogSize = dimension;
    }

    public void setMainFrameHDividerLocation(int n) {
        this.mainFrameHDividerLocation = n;
    }

    public void setMainFrameVDividerLocation(int n) {
        this.mainFrameVDividerLocation = n;
    }

    public void setCurrentLookAndFeel(int n) {
        this.currentLookAndFeel = n;
    }

    public void setCurrentTreeView(int n) {
        this.currentTreeView = n;
    }

    public void setExpandTreeCheckBox(boolean bl) {
        this.expandTreeCheckBox = bl;
    }

    public void setShowNumbersAsHexCheckBox(boolean bl) {
        this.showNumbersAsHexCheckBox = bl;
    }

    public void setAutoLoadCheckBox(boolean bl) {
        this.autoLoadCheckBox = bl;
    }

    public void setAutoDeleteEntryOnCopy(boolean bl) {
        this.autoDeleteEntryOnCopy = bl;
    }

    public void setShowJCL12PropView(boolean bl) {
        this.showJCL12PropView = bl;
    }

    public void setFileDialogPath(String string) {
        this.fileDialogPath = string;
    }
}

