/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.editor;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jpos.config.simple.editor.MainFrame;

public class JposEntryEditor {
    private static JFrame frame = null;
    private static boolean defaultCloseOperationSet = false;
    public static final int DO_NOTHING_ON_CLOSE = 0;
    public static final int HIDE_ON_CLOSE = 1;
    public static final int DISPOSE_ON_CLOSE = 2;
    public static final int EXIT_ON_CLOSE = 3;
    public static final String COULD_NOT_JCLEDITOR_MSG = "Could not run JCL Editor.  Please see install documentation and try again.";
    public static final String JCL_PREREQUISITE_CLASSES_NOT_FOUND_MSG = "The JCL prerequisite classes (controls and JCL and Apache.org Xerces XML parser) not found!";
    public static final String JCL_ERROR_TITLE_STRING = "JCL Editor Error Dialog";

    private JposEntryEditor() {
    }

    private static boolean verifyPrerequisites() {
        boolean bl = false;
        try {
            JposEntryEditor.checkJclClasses();
            JposEntryEditor.checkXercesClasses();
            bl = true;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new JFrame(), JCL_PREREQUISITE_CLASSES_NOT_FOUND_MSG, JCL_ERROR_TITLE_STRING, 0);
        }
        return bl;
    }

    private static void checkJclClasses() throws ClassNotFoundException {
        Class.forName("jpos.config.JposEntry");
        Class.forName("jpos.config.simple.SimpleEntry");
        Class.forName("jpos.loader.JposServiceInstance");
        Class.forName("jpos.loader.simple.SimpleServiceConnection");
    }

    private static void checkXercesClasses() throws ClassNotFoundException {
        Class.forName("org.w3c.dom.Document");
        Class.forName("org.apache.xerces.parsers.DOMParser");
    }

    public static void main(String[] stringArray) {
        if (!JposEntryEditor.verifyPrerequisites()) {
            System.out.println(COULD_NOT_JCLEDITOR_MSG);
            System.exit(0);
        }
        if (!defaultCloseOperationSet) {
            JposEntryEditor.getFrame().setDefaultCloseOperation(3);
            defaultCloseOperationSet = true;
        }
        JposEntryEditor.getFrame().setVisible(true);
    }

    public static void setFrameVisible(boolean bl) {
        JposEntryEditor.getFrame().setVisible(bl);
    }

    public static void setDefaultFrameCloseOperation(int n) {
        JposEntryEditor.getFrame().setDefaultCloseOperation(n);
        defaultCloseOperationSet = true;
    }

    public static JFrame getFrame() {
        if (frame == null) {
            frame = new MainFrame();
        }
        return frame;
    }
}

