/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.tools.sdist.panels;

import com.ibm.jpos.tools.sdist.SdistAppModel;
import com.ibm.jpos.tools.sdist.SdistConst;
import com.ibm.jpos.tools.sdist.panels.SdistAppPanel;
import com.ibm.jpos.tools.sdist.panels.SdistPnlMainPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class SdistPnlOptions
extends JPanel
implements SdistAppPanel {
    private JTabbedPane jTab;
    private JPanel jPnlGeneral = null;
    private JButton jBtnExplore;
    private JTextField jTxtFilePath;
    private JLabel jLblFilePath;
    public static final String PANEL_ID = "Options";

    public SdistPnlOptions() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.jTab = new JTabbedPane();
            this.add((Component)this.jTab, "Center");
            this.jTab.setPreferredSize(new Dimension(78, 147));
            this.jPnlGeneral = new JPanel();
            this.jTab.addTab(SdistConst.MSG_MAINMENUOP2, null, this.jPnlGeneral, null);
            this.jPnlGeneral.setPreferredSize(new Dimension(527, 145));
            this.jPnlGeneral.setLayout(null);
            this.jLblFilePath = new JLabel();
            this.jPnlGeneral.add(this.jLblFilePath);
            this.jLblFilePath.setText(SdistConst.MSG_SUPPORTFILESLOCATION);
            this.jLblFilePath.setBounds(42, 63, 392, 28);
            this.jTxtFilePath = new JTextField();
            this.jPnlGeneral.add(this.jTxtFilePath);
            this.jTxtFilePath.setBounds(42, 91, 518, 28);
            this.jTxtFilePath.setEditable(false);
            this.jBtnExplore = new JButton();
            this.jPnlGeneral.add(this.jBtnExplore);
            this.jBtnExplore.setText(SdistConst.MSG_EXPLORE);
            this.jBtnExplore.setBounds(574, 91, 63, 28);
            this.jBtnExplore.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SdistPnlOptions.this.handleExploreBtn();
                }
            });
            this.setSize(540, 358);
            this.setPreferredSize(new Dimension(673, 358));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void handleExploreBtn() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        File swingFile = new File(this.jTxtFilePath.getText());
        if (swingFile.exists()) {
            fc.setCurrentDirectory(swingFile);
            fc.setSelectedFile(swingFile);
        }
        while (true) {
            fc.setFileSelectionMode(1);
            int result = fc.showOpenDialog(null);
            if (result != 0) break;
            String path = fc.getSelectedFile().getAbsolutePath().trim();
            if (SdistAppModel.validateDirectory(path = SdistAppModel.standarizePathToShow(path))) {
                if (SdistAppModel.validateFileWritable(path)) {
                    this.jTxtFilePath.setText(path);
                    return;
                }
                JOptionPane.showMessageDialog(this, path + " " + SdistConst.MSG_READONLYPATH, SdistConst.MSG_ERROR, 0);
                continue;
            }
            JOptionPane.showMessageDialog(this, SdistConst.MSG_INVALIDFILE, SdistConst.MSG_ERROR, 0);
        }
    }

    public String getNextPanelID() {
        return null;
    }

    public String getPrevPanelID() {
        return SdistPnlMainPanel.PANEL_ID;
    }

    public boolean beforeHidePanel() {
        try {
            String path = this.jTxtFilePath.getText();
            if (path != null) {
                path = path.trim();
            }
            if (path.equalsIgnoreCase("") || !SdistAppModel.validateDirectory(path)) {
                JOptionPane.showMessageDialog(this, path + " " + SdistConst.MSG_INVALIDPATH, SdistConst.MSG_ERROR, 0);
                return false;
            }
            if (!SdistAppModel.validateFileWritable(path)) {
                JOptionPane.showMessageDialog(this, path + " " + SdistConst.MSG_READONLYPATH, SdistConst.MSG_ERROR, 0);
                return false;
            }
            SdistAppModel mdl = SdistAppModel.getInstance();
            mdl.setSessionFilesPath(path);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), SdistConst.MSG_ERROR, 0);
            return false;
        }
        return true;
    }

    public boolean beforeShowPanel() {
        SdistAppModel mdl = SdistAppModel.getInstance();
        this.jTxtFilePath.setText(mdl.getSessionFilesPath());
        return true;
    }

    public void afterShowPanel() {
    }

    public String getID() {
        return PANEL_ID;
    }
}

