/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.tools.sdist;

import com.ibm.jpos.tools.sdist.SdistAppController;
import com.ibm.jpos.tools.sdist.SdistAppModel;
import com.ibm.jpos.tools.sdist.SdistBaseFrame;
import com.ibm.jpos.tools.sdist.SdistConst;
import com.ibm.jpos.tools.sdist.panels.SdistAppPanel;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Event;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class SdistAppView
extends WindowAdapter {
    JFrame owner;
    private SdistAppModel myModel;
    private JPanel panel;
    private CardLayout cardLayout;
    private SdistAppController myController;
    private JButton backButton;
    private JButton nextButton;
    private JButton cancelButton;
    private Tracer tracer = TracerFactory.getInstance().createTracer("SdistAppView");

    public SdistAppView(JFrame owner) {
        this.owner = owner;
        if (this.tracer.isOn()) {
            this.tracer.println(3, "-->SdistAppView");
        }
        this.myModel = SdistAppModel.getInstance();
        this.myModel.setView(this);
        owner.setSize(754, 520);
        SdistBaseFrame.center(owner);
        this.initGUI();
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<--SdistAppView");
        }
    }

    public void addPanel(Object key, SdistAppPanel panel) {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "-->addPanel " + (String)key);
        }
        this.panel.add((Component)((JPanel)((Object)panel)), key);
        this.myModel.addPanel(key, panel);
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<--addPanel");
        }
    }

    public void setCurrentPanel(Object key) {
        SdistAppPanel oldPanel;
        if (this.tracer.isOn()) {
            this.tracer.println(3, "-->setCurrentPanel");
        }
        if (key == null) {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "<--setCurrentPanel");
            }
            this.close(3);
        }
        if ((oldPanel = this.myModel.getCurrentPanel()) != null && !oldPanel.beforeHidePanel()) {
            return;
        }
        try {
            this.myModel.setCurrentPanel(key);
        }
        catch (Exception e) {
            if (this.tracer.isOn()) {
                this.tracer.println(2, "<--setCurrentPanel:" + e.getStackTrace());
            }
            return;
        }
        this.myModel.getCurrentPanel().beforeShowPanel();
        this.cardLayout.show(this.panel, key.toString());
        this.myModel.getCurrentPanel().afterShowPanel();
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<--setCurrentPanel");
        }
    }

    public void ProcessEvent(Event event, SdistAppPanel oldPanel, SdistAppPanel currentPanel) {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "-->processEvent");
        }
        switch (event.id) {
            case 1: {
                this.nextButton.setText((String)event.arg);
                break;
            }
            case 2: {
                this.backButton.setText((String)event.arg);
                break;
            }
            case 3: {
                this.cancelButton.setText((String)event.arg);
                break;
            }
            case 4: {
                this.nextButton.setEnabled((Boolean)event.arg);
                break;
            }
            case 6: {
                this.backButton.setEnabled((Boolean)event.arg);
                break;
            }
            case 5: {
                this.cancelButton.setEnabled((Boolean)event.arg);
                break;
            }
            case 7: {
                this.updateMainButtons();
            }
        }
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<--processEvent");
        }
    }

    public void close(int code) {
        if (code == 2) {
            if (this.myModel.getMode() == 2) {
                JOptionPane.showMessageDialog(this.owner, "Session files generated in " + this.myModel.getSessionFilesPath(), "Information", 1);
            }
            if (this.myModel.getMode() == 1) {
                JOptionPane.showMessageDialog(this.owner, "Trace configuration updated.", "Information", 1);
            }
        }
        this.owner.dispose();
        System.exit(0);
    }

    public SdistAppModel getModel() {
        return this.myModel;
    }

    private void initGUI() {
        this.myController = new SdistAppController(this);
        this.owner.getContentPane().setLayout(new BorderLayout());
        this.owner.addWindowListener(this);
        JPanel buttonPanel = new JPanel();
        JSeparator separator = new JSeparator();
        Box buttonBox = new Box(0);
        this.panel = new JPanel();
        this.panel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.cardLayout = new CardLayout();
        this.panel.setLayout(this.cardLayout);
        this.backButton = new JButton();
        this.nextButton = new JButton();
        this.cancelButton = new JButton();
        this.backButton.setActionCommand("CMDPREV");
        this.nextButton.setActionCommand("CMDNEXT");
        this.cancelButton.setActionCommand("CMDCANCEL");
        this.backButton.addActionListener(this.myController);
        this.nextButton.addActionListener(this.myController);
        this.cancelButton.addActionListener(this.myController);
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.add((Component)separator, "North");
        buttonBox.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        buttonBox.add(this.backButton);
        buttonBox.add(Box.createHorizontalStrut(5));
        buttonBox.add(this.nextButton);
        buttonBox.add(Box.createHorizontalStrut(40));
        buttonBox.add(this.cancelButton);
        buttonPanel.add((Component)buttonBox, "East");
        this.owner.getContentPane().add((Component)buttonPanel, "South");
        this.owner.getContentPane().add((Component)this.panel, "Center");
    }

    private void updateMainButtons() {
        SdistAppPanel pnl = this.myModel.getCurrentPanel();
        if (pnl == null) {
            return;
        }
        this.cancelButton.setText(SdistConst.MSG_BTN_CANCEL);
        this.backButton.setText(SdistConst.MSG_BTN_PREV);
        this.backButton.setEnabled(pnl.getPrevPanelID() != null);
        if (pnl.getNextPanelID() != null) {
            this.nextButton.setEnabled(true);
            this.nextButton.setText(SdistConst.MSG_BTN_NEXT);
        } else {
            this.nextButton.setText(SdistConst.MSG_BTN_FINISH);
        }
    }
}

