/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.tools.sdist;

import com.ibm.jpos.tools.sdist.SdistAppView;
import com.ibm.jpos.tools.sdist.SdistConst;
import com.ibm.jpos.tools.sdist.model.EnvironmentModel;
import com.ibm.jpos.tools.sdist.model.JavaPOSTracingModel;
import com.ibm.jpos.tools.sdist.panels.SdistAppPanel;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.awt.Event;
import java.io.File;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class SdistAppModel {
    public static final int MODE_STARTSESSION = 1;
    public static final int MODE_ENDSESSION = 2;
    private int modelMode = 1;
    private SdistAppPanel currentPanel;
    private HashMap panels = null;
    private HashMap javaPosProps = null;
    private SdistAppView myView = null;
    private static SdistAppModel myInstance = null;
    private Tracer tracer = TracerFactory.getInstance().createTracer("SdistAppModel");
    public static final char[] invalidFileCharacters = new char[]{'\\', '/', ':', '*', '?', '\'', '<', '>', '|', '\"'};
    public static final char[] invalidPathCharacters = new char[]{'*', '?', '\'', '<', '>', '|', '\"'};

    public static SdistAppModel getInstance() {
        if (myInstance == null) {
            myInstance = new SdistAppModel();
        }
        return myInstance;
    }

    private SdistAppModel() {
        this.panels = new HashMap();
    }

    public void setView(SdistAppView view) {
        this.myView = view;
    }

    public SdistAppPanel getCurrentPanel() {
        return this.currentPanel;
    }

    public void addPanel(Object key, SdistAppPanel panel) {
        this.panels.put(key, panel);
    }

    public void setCurrentPanel(Object key) throws Exception {
        SdistAppPanel newPanel;
        if (this.tracer.isOn()) {
            this.tracer.println(3, "-->setCurrentPanel" + (String)key);
        }
        if ((newPanel = (SdistAppPanel)this.panels.get(key)) == null) {
            throw new Exception(SdistConst.MSG_INTERNALERROR);
        }
        SdistAppPanel oldPanel = this.currentPanel;
        this.currentPanel = newPanel;
        if (oldPanel != this.currentPanel && this.myView != null) {
            this.myView.ProcessEvent(new Event(this, 7, null), oldPanel, this.currentPanel);
        }
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<--setCurrentPanel");
        }
    }

    public Object[] getLevels() {
        return new String[]{"Minimum", "Normal", "Maximum"};
    }

    public Object[] getOutputs() {
        return new String[]{"Console", "File", "Logging"};
    }

    public Object[] getTimeStampFormats() {
        return new String[]{"DATE", "MSECS"};
    }

    public String getSessionFilesPath() {
        return EnvironmentModel.getInstance().getSendFolderLocation();
    }

    public void setSessionFilesPath(String sessionPath) {
        EnvironmentModel.getInstance().setSendFolderLocation(sessionPath);
    }

    public boolean close(int rtn) {
        try {
            if (!this.currentPanel.beforeHidePanel()) {
                return false;
            }
            if (rtn == 2 && this.modelMode == 1) {
                JavaPOSTracingModel mdl = JavaPOSTracingModel.getInstance();
                mdl.setAllTraceProps(this.javaPosProps);
                mdl.saveChanges();
            } else if (rtn == 2 && this.modelMode == 2) {
                JavaPOSTracingModel mdl = JavaPOSTracingModel.getInstance();
                mdl.endSession(EnvironmentModel.getInstance().getSendFolderLocation());
            }
            return true;
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (e.getMessage() == null) {
                message = SdistConst.MSG_SENDFOLDERDONOTEXIST;
            } else if (e.getMessage().equalsIgnoreCase("INT1")) {
                message = SdistConst.MSG_SENDFOLDERDONOTEXIST;
            }
            JOptionPane.showMessageDialog(this.myView.owner, message, SdistConst.MSG_ERROR, 0);
            return false;
        }
    }

    public void setMode(int mode) {
        JavaPOSTracingModel mdl = JavaPOSTracingModel.getInstance();
        this.modelMode = mode;
        if (this.modelMode != 2) {
            this.javaPosProps = mdl.getAllTraceProps();
        }
    }

    public int getMode() {
        return this.modelMode;
    }

    public void setJavaPOSTraceProps() {
        JavaPOSTracingModel mdl = JavaPOSTracingModel.getInstance();
        mdl.setAllTraceProps(this.javaPosProps);
    }

    public HashMap getJavaPOSTraceProps() {
        return this.javaPosProps;
    }

    public void initJavaPOSTraceProps() {
        this.javaPosProps = JavaPOSTracingModel.getInstance().getAllDefaultProps();
    }

    public boolean isJavaPOSTraceEnabled() {
        return JavaPOSTracingModel.getInstance().isTraceEnabled();
    }

    public static boolean validateFile(String fileName) {
        try {
            File file = new File(fileName);
            file.createNewFile();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean validateDirectory(String path) {
        try {
            File file = new File(path);
            if (file.isDirectory()) {
                return true;
            }
            return file.mkdirs();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean validateFileWritable(String fileName) {
        try {
            File file = new File(fileName);
            return file.canWrite();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String standarizePathToShow(String path) {
        String rtn = path;
        try {
            if (File.separatorChar != '/') {
                rtn = path.replace('/', File.separatorChar);
            }
            if (File.separatorChar != '\\') {
                rtn = path.replace('\\', File.separatorChar);
            }
            return rtn;
        }
        catch (Exception e) {
            return path;
        }
    }

    public static String standarizePathToSave(String path) {
        return path.replace('\\', '/');
    }
}

